using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;
using System.Timers;
using System.Diagnostics;

namespace PopupKiller
{

	/// <summary>
	/// Summary description for Form1.
	/// </summary>
	public class Form1 : System.Windows.Forms.Form
	{
		private System.Windows.Forms.ListView listView1;
		private System.Windows.Forms.ColumnHeader columnHeader1;
		private System.Windows.Forms.NotifyIcon notifyIcon1;
		private System.Windows.Forms.ContextMenu contextMenu_WebPages;
		private System.Windows.Forms.ContextMenu contextMenu_App;
		private System.Windows.Forms.MenuItem App_Hide;
		private System.Windows.Forms.MenuItem App_Show;
		private System.Windows.Forms.MenuItem App_Exit;
		private System.Windows.Forms.MenuItem App_About;
		private System.Windows.Forms.MenuItem App_Save;
		private System.Windows.Forms.MenuItem WebPages_Add;
		private System.Windows.Forms.MenuItem WebPages_Edit;
		private System.Windows.Forms.MenuItem WebPages_Remove;
		private System.Windows.Forms.MenuItem separator;
		private System.ComponentModel.IContainer components;

		// 
		private System.Timers.Timer m_Timer;
		private	int m_nInterval;

		private System.Windows.Forms.MenuItem App_HotKey; // milliseconds

		// const
		protected const String m_sFilename = "PopupKiller.log.xml";

		protected Keys m_hotkey;
		protected bool m_ctrlhotkey, m_shifthotkey, m_althotkey, m_winhotkey;


		public Form1()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			// register default hot key (overriden by .xml file in <hotkey...>...</hotkey>)
			//
			m_hotkey = Keys.J; // default hotkey is Ctrl+Shift+J
			m_ctrlhotkey = true;
			m_shifthotkey = true;
			m_althotkey = false;
			m_winhotkey = false;
			SetHotKey(m_hotkey, m_ctrlhotkey, m_shifthotkey, m_althotkey, m_winhotkey);


			// load xml file and fill listview with banned pages
			//
			LoadPages(); 

			// enable timer for regular check
			//
			m_Timer = new System.Timers.Timer(); // explicit namespace because Timer is declared in System.Threading too
			m_Timer.Elapsed += new ElapsedEventHandler(OnTimerKillPopup);
			Interval = 3000; // every 3 seconds
			EnableTimer();

		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if (components != null) 
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(Form1));
			System.Configuration.AppSettingsReader configurationAppSettings = new System.Configuration.AppSettingsReader();
			this.listView1 = new System.Windows.Forms.ListView();
			this.columnHeader1 = new System.Windows.Forms.ColumnHeader();
			this.contextMenu_WebPages = new System.Windows.Forms.ContextMenu();
			this.WebPages_Add = new System.Windows.Forms.MenuItem();
			this.WebPages_Edit = new System.Windows.Forms.MenuItem();
			this.WebPages_Remove = new System.Windows.Forms.MenuItem();
			this.notifyIcon1 = new System.Windows.Forms.NotifyIcon(this.components);
			this.contextMenu_App = new System.Windows.Forms.ContextMenu();
			this.App_About = new System.Windows.Forms.MenuItem();
			this.App_HotKey = new System.Windows.Forms.MenuItem();
			this.App_Save = new System.Windows.Forms.MenuItem();
			this.separator = new System.Windows.Forms.MenuItem();
			this.App_Hide = new System.Windows.Forms.MenuItem();
			this.App_Show = new System.Windows.Forms.MenuItem();
			this.App_Exit = new System.Windows.Forms.MenuItem();
			this.SuspendLayout();
			// 
			// listView1
			// 
			this.listView1.Columns.AddRange(new System.Windows.Forms.ColumnHeader[] {
																						this.columnHeader1});
			this.listView1.ContextMenu = this.contextMenu_WebPages;
			this.listView1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.listView1.LabelEdit = true;
			this.listView1.Name = "listView1";
			this.listView1.Size = new System.Drawing.Size(240, 389);
			this.listView1.TabIndex = 0;
			this.listView1.View = System.Windows.Forms.View.Details;
			// 
			// columnHeader1
			// 
			this.columnHeader1.Text = "Web pages";
			this.columnHeader1.Width = 230;
			// 
			// contextMenu_WebPages
			// 
			this.contextMenu_WebPages.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																								 this.WebPages_Add,
																								 this.WebPages_Edit,
																								 this.WebPages_Remove});
			this.contextMenu_WebPages.Popup += new System.EventHandler(this.menu_WebPages_BeforePopup);
			// 
			// WebPages_Add
			// 
			this.WebPages_Add.Index = 0;
			this.WebPages_Add.Text = "Add";
			this.WebPages_Add.Click += new System.EventHandler(this.menu_WebPages_Add);
			// 
			// WebPages_Edit
			// 
			this.WebPages_Edit.Index = 1;
			this.WebPages_Edit.Text = "Edit";
			this.WebPages_Edit.Click += new System.EventHandler(this.menu_WebPages_Edit);
			// 
			// WebPages_Remove
			// 
			this.WebPages_Remove.Index = 2;
			this.WebPages_Remove.Text = "Remove";
			this.WebPages_Remove.Click += new System.EventHandler(this.menu_WebPages_Remove);
			// 
			// notifyIcon1
			// 
			this.notifyIcon1.ContextMenu = this.contextMenu_App;
			this.notifyIcon1.Icon = ((System.Drawing.Icon)(resources.GetObject("notifyIcon1.Icon")));
			this.notifyIcon1.Text = ((string)(configurationAppSettings.GetValue("notifyIcon1.Text", typeof(string))));
			this.notifyIcon1.Visible = true;
			this.notifyIcon1.DoubleClick += new System.EventHandler(this.notifyIcon1_DoubleClick);
			// 
			// contextMenu_App
			// 
			this.contextMenu_App.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
																							this.App_About,
																							this.App_HotKey,
																							this.App_Save,
																							this.separator,
																							this.App_Hide,
																							this.App_Show,
																							this.App_Exit});
			this.contextMenu_App.Popup += new System.EventHandler(this.menu_App_BeforePopup);
			// 
			// App_About
			// 
			this.App_About.Index = 0;
			this.App_About.Text = "About";
			this.App_About.Click += new System.EventHandler(this.menu_App_About);
			// 
			// App_HotKey
			// 
			this.App_HotKey.Index = 1;
			this.App_HotKey.Text = "Hotkey";
			this.App_HotKey.Click += new System.EventHandler(this.menu_App_HotKey);
			// 
			// App_Save
			// 
			this.App_Save.Index = 2;
			this.App_Save.Text = "Save";
			this.App_Save.Click += new System.EventHandler(this.menu_App_Save);
			// 
			// separator
			// 
			this.separator.Index = 3;
			this.separator.Text = "-";
			// 
			// App_Hide
			// 
			this.App_Hide.Index = 4;
			this.App_Hide.Text = "Hide";
			this.App_Hide.Click += new System.EventHandler(this.menu_App_Hide);
			// 
			// App_Show
			// 
			this.App_Show.Index = 5;
			this.App_Show.Text = "Show";
			this.App_Show.Click += new System.EventHandler(this.menu_App_Show);
			// 
			// App_Exit
			// 
			this.App_Exit.Index = 6;
			this.App_Exit.Text = "Exit";
			this.App_Exit.Click += new System.EventHandler(this.menu_App_Exit);
			// 
			// Form1
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(240, 389);
			this.ContextMenu = this.contextMenu_App;
			this.Controls.AddRange(new System.Windows.Forms.Control[] {
																		  this.listView1});
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.Name = "Form1";
			this.ShowInTaskbar = false;
			this.Text = "Popup Killer";
			this.WindowState = System.Windows.Forms.FormWindowState.Minimized;
			this.ResumeLayout(false);

		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main() 
		{
			Application.Run(new Form1());
		}


		public int Interval
		{
			get { 
				return m_nInterval; 
			}
			set {
				m_nInterval = value;
				m_Timer.Interval = m_nInterval;
			}
		}



// Application main context menu handlers
//
//

		private void menu_App_About(object sender, System.EventArgs e)
		{
			MessageBox.Show("Popup Killer. (c) SRodriguez 2002");
		}

		private void menu_App_Save(object sender, System.EventArgs e)
		{
			System.Xml.XmlTextWriter w = new System.Xml.XmlTextWriter(m_sFilename, new System.Text.UTF8Encoding());
			w.Formatting = System.Xml.Formatting.Indented; 
			w.WriteStartDocument();
			w.WriteStartElement("popupkiller"); // <popupkiller>
			foreach (ListViewItem item in listView1.Items)
			{
				w.WriteStartElement("page"); // <page>
				w.WriteString( item.Text );
				w.WriteEndElement(); // </page>
			}

			w.WriteStartElement("hotkey"); // <hotkey>
			w.WriteAttributeString("ctrl",m_ctrlhotkey?"true":"false");
			w.WriteAttributeString("shift",m_shifthotkey?"true":"false");
			w.WriteAttributeString("alt",m_althotkey?"true":"false");
			w.WriteAttributeString("windows",m_winhotkey?"true":"false");
			int n = (int) m_hotkey;
			w.WriteString( n.ToString() );
			w.WriteEndElement(); // </hotkey>

			w.WriteEndElement(); // </popupkiller>
			w.Close();
		}

		public void LoadPages()
		{
			System.Xml.XmlTextReader reader = null;

			// if the .xml file does not exist, avoid stupid exception.
			if (!System.IO.File.Exists(m_sFilename)) return;

			try
			{  
				//Load the reader with the data file and ignore all white space nodes.         
				reader = new System.Xml.XmlTextReader(m_sFilename);
				reader.WhitespaceHandling = System.Xml.WhitespaceHandling.None;
	
				bool bEnablePageContent = false; // used to filter <page>...</page> content
				bool bEnableHotkeyContent = false; // used to filter <hotkey ...>...</hotkey> content

				//Parse the file and display each of the nodes.
				while (reader.Read())
				{
					switch (reader.NodeType)
					{
						case System.Xml.XmlNodeType.Element:
							// are we parsing a <page> element ?
							bEnablePageContent = (reader.Name=="page");
							bEnableHotkeyContent = (reader.Name=="hotkey");
							break;
						case System.Xml.XmlNodeType.Text:
							// we are parsing a <page> declaration
							// let's add this page to our listview
							if (bEnablePageContent)
								listView1.Items.Add( reader.Value );
							else if (bEnableHotkeyContent)
							{
								m_hotkey = (Keys) System.Int32.Parse(reader.Value);
								SetHotKey(m_hotkey, m_ctrlhotkey, m_shifthotkey, m_althotkey, m_winhotkey); // register hotkey
							}

							bEnablePageContent = false;
							bEnableHotkeyContent = false;
							break;
						case System.Xml.XmlNodeType.Attribute:
							if (bEnableHotkeyContent)
							{
								if (reader.Name=="ctrl")
									m_ctrlhotkey = (reader.Value=="true")?true:false;
								if (reader.Name=="shift")
									m_shifthotkey = (reader.Value=="true")?true:false;
								if (reader.Name=="alt")
									m_althotkey = (reader.Value=="true")?true:false;
								if (reader.Name=="windows")
									m_winhotkey = (reader.Value=="true")?true:false;
							}
							break;

					}       
				} // end while      
			}
			catch( System.Xml.XmlException e)
			{
				e.ToString();
			}
			finally
			{
				if (reader!=null) reader.Close();
			}
		}

		private void menu_App_Hide(object sender, System.EventArgs e)
		{
			this.WindowState = FormWindowState.Minimized;
			Hide();
		}

		private void menu_App_Show(object sender, System.EventArgs e)
		{
			Show();
			this.WindowState = FormWindowState.Normal;
		}

		private void menu_App_Exit(object sender, System.EventArgs e)
		{

			// unregister hotkey
			//
			NativeWIN32.UnregisterHotKey(Handle, 100);


			notifyIcon1.Visible = false; // hide icon from the systray
			Application.Exit();
		}

		// event not attached to a delegate, (simple override).
		protected override void OnClosing(CancelEventArgs e)
		{
			// method overidden so the form can be minimized, instead of closed
			if (this.Visible==true)
			{
				e.Cancel = true;
				// let's minimize the form, and hide it
				this.WindowState = FormWindowState.Minimized;
				Hide();
			}

			// otherwise, let the framework close the app
		}

		private void menu_App_BeforePopup(object sender, System.EventArgs e)
		{
			if ( this.WindowState == FormWindowState.Minimized )
			{
				App_Show.Enabled = true;
				App_Hide.Enabled = false;
			}
			else
			{
				App_Show.Enabled = false;
				App_Hide.Enabled = true;
			}
		}

		// when double-clicking the icon in the systray, just show up the form
		private void notifyIcon1_DoubleClick(object sender, System.EventArgs e)
		{
			this.WindowState = FormWindowState.Normal;
			Show();
		}


		
// Webpage context menu handlers
//
//

		private void menu_WebPages_Add(object sender, System.EventArgs e)
		{
			listView1.Items.Add( "***EDIT PAGE***" );
		}

		private void menu_WebPages_Edit(object sender, System.EventArgs e)
		{
			if ( listView1.SelectedItems.Count==1 )
				listView1.SelectedItems[0].BeginEdit();
		}

		private void menu_WebPages_Remove(object sender, System.EventArgs e)
		{
			ListView.SelectedListViewItemCollection selcoll = listView1.SelectedItems;

			while ( selcoll.Count>0 )// warning : sellcoll.Count dynamically updated by listView1.Items.Remove(...)
				listView1.Items.Remove( selcoll[0] );
		}

		private void menu_WebPages_BeforePopup(object sender, System.EventArgs e)
		{
			WebPages_Edit.Enabled = ( listView1.SelectedItems.Count==1 );
		}



// Timer handlers
//
//

		protected void EnableTimer()
		{
			m_Timer.Enabled = true;
		}
		protected void DisableTimer()
		{
			m_Timer.Enabled = false;
		}
		protected bool IsTimerEnabled()
		{
			return m_Timer.Enabled;
		}

		protected void OnTimerKillPopup(Object source, ElapsedEventArgs e)
		{

			DisableTimer();


			if (true) // using WIN32 FindWindowEx : do a direct traverse of all Internet Explorer windows
				FindPopupToKill();
			else // traverse processes -> threads -> windows
			{
				Process[] myProcesses = Process.GetProcessesByName("IEXPLORE");
				// Display process parameters for each process.
				foreach(Process myProcess in myProcesses)
				{
					FindPopupToKill(myProcess);
				}
			}


			EnableTimer();
		}


		protected void FindPopupToKill()
		{
			IntPtr hParent = IntPtr.Zero;
			IntPtr hNext = IntPtr.Zero;
			String sClassNameFilter = "IEFrame"; // Internet Explorer CLASSNAME of all its windows
			do
			{
				hNext = NativeWIN32.FindWindowEx(hParent,hNext,sClassNameFilter,IntPtr.Zero);

				// we've got a hwnd to play with
				if ( !hNext.Equals(IntPtr.Zero) )
				{
					// get window caption
					NativeWIN32.STRINGBUFFER sLimitedLengthWindowTitle;
					NativeWIN32.GetWindowText(hNext, out sLimitedLengthWindowTitle, 256);

					String sWindowTitle = sLimitedLengthWindowTitle.szText;
					if (sWindowTitle.Length>0)
					{
						// find this caption in the list of banned captions
						foreach (ListViewItem item in listView1.Items)
						{
							if ( sWindowTitle.StartsWith(item.Text) )
								NativeWIN32.SendMessage(hNext, NativeWIN32.WM_SYSCOMMAND, NativeWIN32.SC_CLOSE, IntPtr.Zero); // try soft kill
						}
					}
				}
			} 
			while (!hNext.Equals(IntPtr.Zero));

		}

		protected void FindPopupToKill(Process p)
		{
			// traverse all threads from the current process and enum all windows attached to the thread
			foreach (ProcessThread t in p.Threads)
			{
				int threadId = t.Id;

				NativeWIN32.EnumThreadProc callbackProc = new NativeWIN32.EnumThreadProc(MyEnumThreadWindowsProc);
				NativeWIN32.EnumThreadWindows(threadId, callbackProc, IntPtr.Zero /*lParam*/);
			}
		}

		// callback used to enumerate Windows attached to one of the threads of the current process being traversed
		bool MyEnumThreadWindowsProc(IntPtr hwnd, IntPtr lParam)
		{
			// get window caption
			NativeWIN32.STRINGBUFFER sLimitedLengthWindowTitle;
			NativeWIN32.GetWindowText(hwnd, out sLimitedLengthWindowTitle, 256);

			String sWindowTitle = sLimitedLengthWindowTitle.szText;
			if (sWindowTitle.Length==0) return true;

			// find this caption in the list of banned captions
			foreach (ListViewItem item in listView1.Items)
			{
				if ( sWindowTitle.StartsWith(item.Text) )
					NativeWIN32.SendMessage(hwnd, NativeWIN32.WM_SYSCOMMAND, NativeWIN32.SC_CLOSE, IntPtr.Zero); // try soft kill
			}

			return true;
		}





// Hotkey management
//
//

		private void menu_App_HotKey(object sender, System.EventArgs e)
		{
			FormHotkey f = new FormHotkey();

			String sHotKey = "";
			if (m_ctrlhotkey)
				sHotKey += "Ctrl";
			if (m_shifthotkey)
			{
				if (sHotKey.Length!=0)
					sHotKey += " + ";
				sHotKey += "Shift";
			}
			if (m_althotkey)
			{
				if (sHotKey.Length!=0)
					sHotKey += " + ";
				sHotKey += "Alt";
			}
			if (m_winhotkey)
			{
				if (sHotKey.Length!=0)
					sHotKey += " + ";
				sHotKey += "Win";
			}
			if (sHotKey.Length!=0)
				sHotKey += " + ";
			sHotKey += (char)(int)m_hotkey;

			f.SetHotKey(sHotKey);	
			f.SetParentForm(this);
			f.Show();
		}


		protected override void WndProc( ref Message m )
		{	
			const int WM_HOTKEY = 0x0312; 	
	
			switch(m.Msg)	
			{	
				case WM_HOTKEY:		

					IntPtr hwnd = NativeWIN32.GetForegroundWindow();
					if (!hwnd.Equals(IntPtr.Zero))
					{
						NativeWIN32.STRINGBUFFER sWindowTitle;
						NativeWIN32.GetWindowText(hwnd, out sWindowTitle, 256);

						if (sWindowTitle.szText.Length>0)
							AddWindowTitle( sWindowTitle.szText );
					}
					break;	
			} 	
			base.WndProc(ref m );
		}

		public void AddWindowTitle(String sTitle)
		{
			if (sTitle.Length==0) return;

			if (listView1.Items.Count==0)
			{
				listView1.Items.Add(sTitle);
				return;
			}

			// general search
			bool bFound = false;
			foreach (ListViewItem item in listView1.Items)
			{
				bFound = sTitle.StartsWith( item.Text );
			}

			if (!bFound)
				listView1.Items.Add(sTitle);

		}

		public void SetHotKey(Keys c, bool bCtrl, bool bShift, bool bAlt, bool bWindows)
		{
			m_hotkey = c;
			m_ctrlhotkey = bCtrl;
			m_shifthotkey = bShift;
			m_althotkey = bAlt;
			m_winhotkey = bWindows;

			// update hotkey
			NativeWIN32.KeyModifiers modifiers = NativeWIN32.KeyModifiers.None;
			if (m_ctrlhotkey)
				modifiers |= NativeWIN32.KeyModifiers.Control;
			if (m_shifthotkey)
				modifiers |= NativeWIN32.KeyModifiers.Shift;
			if (m_althotkey)
				modifiers |= NativeWIN32.KeyModifiers.Alt;
			if (m_winhotkey)
				modifiers |= NativeWIN32.KeyModifiers.Windows;


			NativeWIN32.RegisterHotKey(Handle, 100, modifiers, m_hotkey); //Keys.J);
		}


	}
}
